<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice #{{ $order->order_number }}</title>

    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 13px; }
        .header { display:flex; justify-content:space-between; margin-bottom:20px; }
        .title { font-size:22px; font-weight:bold; }
        .table { width:100%; border-collapse:collapse; margin-top:15px; }
        .table th, .table td {
            border:1px solid #ddd;
            padding:8px;
        }
        .table th { background:#f5f5f5; }
        .text-right { text-align:right; }
        .total { font-size:16px; font-weight:bold; }
    </style>
</head>
<body>

{{-- HEADER --}}
<div class="header">
    <div>
        <div class="title">INVOICE</div>
        <p>Order #: {{ $order->order_number }}</p>
        <p>Date: {{ $order->created_at->format('d M Y') }}</p>
    </div>

    <div>
        <strong>Tappygifts</strong><br>
        Address Line 1<br>
        City, Country<br>
        Phone: +91 XXXXXXXX
    </div>
</div>

{{-- CUSTOMER --}}
<p>
<strong>Bill To:</strong><br>
{{ $order->user->name }}<br>
{{ $order->user->email }}<br>
{{ $order->shipping_address }}
</p>

{{-- PRODUCTS --}}
<table class="table">
<thead>
<tr>
    <th>#</th>
    <th>Product</th>
    <th>Qty</th>
    <th>Price</th>
    <th>Tax</th>
    <th>Total</th>
</tr>
</thead>

<tbody>
@foreach($order->items as $i => $item)
<tr>
    <td>{{ $i+1 }}</td>
    <td>{{ $item->product->name }}</td>
    <td>{{ $item->qty }}</td>
    <td class="text-right">₹{{ number_format($item->price,2) }}</td>
    <td class="text-right">₹{{ number_format($item->tax,2) }}</td>
    <td class="text-right">₹{{ number_format($item->total,2) }}</td>
</tr>
@endforeach
</tbody>
</table>

{{-- SUMMARY --}}
<table width="100%" style="margin-top:15px">
<tr>
    <td class="text-right">Subtotal:</td>
    <td class="text-right">₹{{ number_format($order->subtotal,2) }}</td>
</tr>
<tr>
    <td class="text-right">Discount:</td>
    <td class="text-right">-₹{{ number_format($order->discount,2) }}</td>
</tr>
<tr>
    <td class="text-right">Tax:</td>
    <td class="text-right">₹{{ number_format($order->tax,2) }}</td>
</tr>
<tr>
    <td class="text-right total">Total:</td>
    <td class="text-right total">₹{{ number_format($order->total,2) }}</td>
</tr>
</table>

<p style="margin-top:30px">
Payment Status: <strong>{{ ucfirst($order->payment_status) }}</strong><br>
Order Status: <strong>{{ ucfirst($order->order_status) }}</strong>
</p>

</body>
</html>
